package some;

import java.util.HashMap;
import java.util.Map;

import net.w_horse.excelpojo.annotation.Bean;
import net.w_horse.excelpojo.annotation.LabeledCell;
import net.w_horse.excelpojo.annotation.MappedCell;
import net.w_horse.excelpojo.annotation.PointedCell;
import net.w_horse.excelpojo.annotation.HorizontalRepeats;
import net.w_horse.excelpojo.xml.tag.DataDirection;
import net.w_horse.excelpojo.xml.tag.RetrieveFrom;


@Bean
public class UserList3 {
	@LabeledCell(label = "^Cg", retrieveFrom = RetrieveFrom.RIGHT)
	private String title1;
	@LabeledCell(label = "^Cg", retrieveFrom = RetrieveFrom.RIGHT, margedLabel = 1)
	private String title2;
	@PointedCell(position = "(3, 2)")
	private String lastUpdate;

	@HorizontalRepeats(targetClass = "some.UserInfo2", label="e[u", retrieveFrom=RetrieveFrom.RIGHT, terminate="Terminate", listClass="some.UserInfo2[]")
	private UserInfo2[] userInfoList;
	@MappedCell(previousLabel="", retrieveFrom=RetrieveFrom.RIGHT, dataDirection=DataDirection.DOWN)
	private Map<String, Integer> numbersMemberMap = new HashMap<String, Integer>();

	public String toString() {
		StringBuffer buff = new StringBuffer("User\t");
		buff.append("title1=" + getTitle1() + ", ");
		buff.append("title2=" + getTitle2() + ", ");
		buff.append("lasUpdate=" + getLastUpdate() + "\n");

		for (UserInfo2 userInfo : getUserInfoList()) {
			buff.append(userInfo.toString() + "\n");
		}

		buff.append(" \n ");
		for (String month : numbersMemberMap.keySet()) {
			Object value = numbersMemberMap.get(month);
			buff.append(String.format(" %s=%s", month, value));
		}
		return buff.toString();
	}

	public void setTitle1(String title1) {
		this.title1 = title1;
	}
	public String getTitle1() {
		return title1;
	}

	public void setTitle2(String title2) {
		this.title2 = title2;
	}
	public String getTitle2() {
		return title2;
	}

	public void setLastUpdate(String lastUpdate) {
		this.lastUpdate = lastUpdate;
	}
	public String getLastUpdate() {
		return lastUpdate;
	}

	public void setUserInfoList(UserInfo2[] userInfoList) {
		this.userInfoList = userInfoList;
	}

	public UserInfo2[] getUserInfoList() {
		return userInfoList;
	}

	public void setNumbersMemberMap(Map<String, Integer> numbersMemberMap) {
		this.numbersMemberMap = numbersMemberMap;
	}

	public Map<String, Integer> getNumbersMemberMap() {
		return numbersMemberMap;
	}


}
